#version 330
#extension GL_EXT_gpu_shader4 : enable
// Metal BallMod01.fsh  by   asalga
//https://www.shadertoy.com/view/MssGRl
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
  Andor Salga
  August 2013
*/

#define PI 3.141592658

vec3 getNormal(in vec2 sphereCenter, in float sphereRadius, in vec2 point){
	// Need to figure out how far the current point is from the center to lerp it
	float distFromCenter = distance(point, sphereCenter);
	float weight = distFromCenter/sphereRadius;
	
	// Z component is zero since at the edge the normal will be on the XY plane
	vec3 edgeNormal = vec3(point - sphereCenter, 0);
	edgeNormal = normalize(edgeNormal);
	
	// We know the normal at the center of the sphere points directly at the viewer,
	// so we can use that in our mix/lerp.
	return mix(vec3(0,0,1), edgeNormal, weight); 
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 center = vec2(iResolution.xy)/2.0;
	
	vec2 spherePos = vec2( sin(iTime), cos(iTime)) * 30.0;
	
	if( distance(center, vec2(gl_FragCoord.xy)) < 240.0){
		vec3 sphereNormal =  vec3(getNormal(center, 240.0, vec2(gl_FragCoord.xy)));
		vec3 dirLight = vec3(0,0,1);
		vec3 col =  normalize((vec3(1, 1, 1))) * dot(sphereNormal, dirLight);
				
		vec3 northVector = vec3(0, 1, 0);
		vec3 eastVector  = vec3(1, 0, 0);
		
		vec3 vertPoint = sphereNormal;
		
		float lat = acos(dot(northVector, sphereNormal));
		float v = lat / PI;
		float u;
		
		float lon = (acos( dot( vertPoint, eastVector) / sin(lat))) / (2.0 * PI);
		if(dot(cross(northVector, eastVector), vertPoint) > 0.0){
			u = lon;
		}
		else{
			u = 1.0 - lon;
		}

		u -= iTime / 20.0;
		
		gl_FragColor = vec4(0.1) + vec4(col * 3.0, 0.5) * texture2D(iChannel0, vec2(u, v));
	}
	else{
		gl_FragColor = vec4(1.);
                gl_FragColor.a = length ( vec3(1.0) - gl_FragColor.rgb );
	}

}